/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import com.google.common.base.Preconditions;
import icyllis.modernui.graphics.font.FontMetricsInt;
import icyllis.modernui.graphics.font.FontPaint;
import icyllis.modernui.graphics.font.GraphemeMetrics;
import icyllis.modernui.graphics.font.LayoutPieces;
import icyllis.modernui.graphics.font.MeasureEngine;
import icyllis.modernui.text.GraphemeBreak;
import icyllis.modernui.text.TextPaint;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public class MeasuredText {
    @Nonnull
    private final char[] mTextBuf;
    @Nonnull
    public final Run[] mRuns;
    public final float[] mAdvances;
    public final LayoutPieces mLayoutPieces = new LayoutPieces();

    private MeasuredText(@Nonnull char[] textBuf, @Nonnull Run[] runs) {
        this.mTextBuf = textBuf;
        this.mRuns = runs;
        this.mAdvances = new float[textBuf.length];
        this.measure(textBuf);
    }

    private void measure(@Nonnull char[] textBuf) {
        if (textBuf.length == 0) {
            return;
        }
        for (Run run : this.mRuns) {
            run.getMetrics(textBuf, this.mAdvances, this.mLayoutPieces);
        }
    }

    @Nonnull
    public char[] getTextBuf() {
        return this.mTextBuf;
    }

    public void getExtent(int start, int end, FontMetricsInt extent) {
        for (Run run : this.mRuns) {
            if (start >= run.mEnd || end <= run.mStart) continue;
            run.getExtent(this.mTextBuf, Math.max(start, run.mStart), Math.min(end, run.mEnd), this.mLayoutPieces, extent);
        }
    }

    public static class ReplacementRun
    extends Run {
        private final float mWidth;
        private final Locale mLocale;

        public ReplacementRun(int start, int end, float width, Locale locale) {
            super(start, end);
            this.mWidth = width;
            this.mLocale = locale;
        }

        @Override
        public void getMetrics(@Nonnull char[] text, @Nonnull float[] advances, @Nonnull LayoutPieces outPieces) {
            advances[this.mStart] = this.mWidth;
        }

        @Override
        public void getExtent(@Nonnull char[] text, int start, int end, @Nonnull LayoutPieces pieces, @Nonnull FontMetricsInt extent) {
        }

        @Override
        public boolean isRtl() {
            return false;
        }

        @Override
        public boolean canBreak() {
            return false;
        }

        @Override
        @Nonnull
        public Locale getLocale() {
            return this.mLocale;
        }
    }

    public static class StyleRun
    extends Run {
        public final FontPaint mPaint;
        private final boolean mIsRtl;

        public StyleRun(int start, int end, FontPaint paint, boolean isRtl) {
            super(start, end);
            this.mPaint = paint;
            this.mIsRtl = isRtl;
        }

        @Override
        public void getMetrics(@Nonnull char[] text, @Nonnull float[] advances, @Nonnull LayoutPieces outPieces) {
            GraphemeBreak.getTextRuns(text, this.getLocale(), this.mStart, this.mEnd, (st, en) -> MeasureEngine.getInstance().create(text, st, en, this.mPaint, this.mIsRtl, (lp, pt) -> {
                advances[st] = lp.mAdvance;
                outPieces.insert(st, en, (GraphemeMetrics)lp, this.mIsRtl, (FontPaint)pt);
            }));
        }

        @Override
        public void getExtent(@Nonnull char[] text, int start, int end, @Nonnull LayoutPieces pieces, @Nonnull FontMetricsInt extent) {
            int paintId = pieces.findPaintId(this.mPaint);
            GraphemeBreak.getTextRuns(text, this.getLocale(), start, end, (st, en) -> pieces.getOrCreate(text, st, en, this.mPaint, this.mIsRtl, paintId, (lp, pt) -> extent.extendBy(lp.mAscent, lp.mDescent)));
        }

        @Override
        public boolean isRtl() {
            return this.mIsRtl;
        }

        @Override
        public boolean canBreak() {
            return true;
        }

        @Override
        @Nonnull
        public Locale getLocale() {
            return this.mPaint.getTextLocale();
        }
    }

    public static abstract class Run {
        public final int mStart;
        public final int mEnd;

        public Run(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }

        public abstract void getMetrics(@Nonnull char[] var1, @Nonnull float[] var2, @Nonnull LayoutPieces var3);

        public abstract void getExtent(@Nonnull char[] var1, int var2, int var3, @Nonnull LayoutPieces var4, @Nonnull FontMetricsInt var5);

        public abstract boolean isRtl();

        public abstract boolean canBreak();

        @Nonnull
        public abstract Locale getLocale();
    }

    public static class Builder {
        private final List<Run> mRuns = new ArrayList<Run>();
        @Nonnull
        private final char[] mText;
        private int mCurrentOffset = 0;

        public Builder(@Nonnull char[] text) {
            this.mText = text;
        }

        public void addStyleRun(@Nonnull TextPaint paint, int length, boolean isRtl) {
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument((end <= this.mText.length ? 1 : 0) != 0, (Object)"Style exceeds the text length");
            this.mRuns.add(new StyleRun(this.mCurrentOffset, end, paint.toMinikin(), isRtl));
            this.mCurrentOffset = end;
        }

        public void addReplacementRun(@Nonnull TextPaint paint, int length, float width) {
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument((end <= this.mText.length ? 1 : 0) != 0, (Object)"Replacement exceeds the text length");
            this.mRuns.add(new ReplacementRun(this.mCurrentOffset, end, width, paint.getTextLocale()));
            this.mCurrentOffset = end;
        }

        @Nonnull
        public MeasuredText build() {
            Preconditions.checkState((this.mCurrentOffset >= 0 ? 1 : 0) != 0, (Object)"Builder can not be reused.");
            Preconditions.checkState((this.mCurrentOffset == this.mText.length ? 1 : 0) != 0, (Object)"Style info has not been provided for all text.");
            this.mCurrentOffset = -1;
            return new MeasuredText(this.mText, this.mRuns.toArray(new Run[0]));
        }
    }
}

